---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-Incremental Static Regeneration（ISR）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 該当なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/lib/incremental-cache/index.ts` - IncrementalCache実装
- E-02: `packages/next/src/server/response-cache/index.ts` - ResponseCache実装
- E-03: `packages/next/src/server/lib/incremental-cache/file-system-cache.ts` - ファイルシステムキャッシュ
- E-04: `packages/next/src/server/lib/incremental-cache/tags-manifest.external.ts` - タグマニフェスト
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IncrementalCacheクラスがISRの中核 | E-01 (84行目) | ○ |
| C-02 | CacheHandlerはget/set/revalidateTagメソッドを持つ | E-01 (63-81行目) | ○ |
| C-03 | CacheHandlerの選択ロジック（カスタム > グローバル > FS） | E-01 (141-157行目) | ○ |
| C-04 | 開発モードではrevalidateが常にstale | E-01 (218-219行目) | ○ |
| C-05 | calculateRevalidateの計算式 | E-01 (231-236行目) | ○ |
| C-06 | ロック機構がDetachedPromiseベース | E-01 (247-283行目) | ○ |
| C-07 | revalidateTagメソッドの存在 | E-01 (285-290行目) | ○ |
| C-08 | NEXT_PRIVATE_DEBUG_CACHEによるデバッグログ | E-01 (97-98行目) | ○ |
| C-09 | オンデマンド再検証のPRERENDER_REVALIDATE_HEADER検証 | E-01 (182-187行目) | ○ |
| C-10 | SharedCacheControlsの初期化 | E-01 (178行目) | ○ |
| C-11 | ResponseCacheのLRUキャッシュ機構 | E-02 (53-56行目) | ○ |
| C-12 | マニフェスト読み込みのリトライ（最大3回、100ms間隔） | E-01 (コンストラクタ内manifest読込参照) + `packages/next/src/server/load-components.ts` (96-110行目) | ○ |
| C-13 | fallback判定のキャッシュ制御 | E-01 (224-229行目) | ○ |
| C-14 | キャッシュキープレフィックスのサポート | E-01 (93行目, 179行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ISRの中核仕様はIncrementalCacheのソースコードで網羅的に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] stale-while-revalidateパターンの具体的な実装フローを確認
- [ ] カスタムCacheHandlerのインターフェース仕様がドキュメントと整合するか確認
